/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package loops;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class StartHere {

    public static void main(String[] args) {
//        simpleLoop();
//        whileLoop();
//        doWhileLoop();
//        exitLoop();
        continueLoop();
//        nestedLoop();
//        exitNestedLoop();
//        exitSpecificLoop();

    }

    public static void simpleLoop() {
        //For loop example, printing out the numbers 1 to 10
        for (int i = 1; i <= 10; i++) {
            System.out.println("i: " + i);
        }
    }

    public static void whileLoop() {
        //while loop example, keep printing until we are done.
        long startTime = System.currentTimeMillis();//Time when we started.
        long timeToRun = 5; //How long we want to spend on our loop (in milliseconds)
        long timeLeft = timeToRun;  //How long we have left to keep looping

        while (timeLeft > 0) {
            System.out.println("We have " + timeLeft + " milliseconds left!");
            timeLeft = timeToRun - (System.currentTimeMillis() - startTime);
        }
    }

    public static void doWhileLoop() {
        //do while loop example, garanteed to run at least once, and then repeat if we have time.
        //set timeToRun to 0 to porve that it will always run at least once!
        long startTime = System.currentTimeMillis();//Time when we started.
        long timeToRun = 0; //How long we want to spend on our loop (in milliseconds)
        long timeLeft = timeToRun;  //How long we have left to keep looping

        do {
            System.out.println("We have " + timeLeft + " milliseconds left!");
            timeLeft = timeToRun - (System.currentTimeMillis() - startTime);
        } while (timeLeft > 0);
    }

    public static void exitLoop() {
        //Exit loop example, count from 1 to 10 but exit if it takes longer than 5 milliseconds.
        long startTime = System.currentTimeMillis();//Time when we started.
        long timeToRun = 5; //How long we want to spend on our loop (in milliseconds)
        for (int i = 1; i <= 10; i++) {
            System.out.println("i: " + i);
            if ((System.currentTimeMillis() - startTime) > timeToRun) {
                break;
            }
        }
    }
    
    public static void continueLoop() {
        //Exit loop example, count from 1 to 100 but exit if it takes longer than 10 milliseconds.
        long startTime = System.currentTimeMillis();//Time when we started.
        long timeToRun = 2; //How long we want to spend an iteration of our loop (in milliseconds)
        for (int i = 1; i <= 10; i++) {
            System.out.println("i: " + i);
            System.out.println("Always do this.");
            if ((System.currentTimeMillis() - startTime) > timeToRun) {
                continue;
            }
            System.out.println("Do this only if you have time.");
        }
    }

    public static void nestedLoop() {
        //outer loop with counter i looping from 1 to 5
        for (int i = 1; i <= 5; i++) {
            System.out.println("Outer loop, iteration number: " + i);
            //inner loop, for each value of i loop through with counter j from 1 to 3
            for (int j = 1; j <= 3; j++) {
                System.out.println("    Inner loop, iteration number: " + j);
            }//end inner loop
        }//end outer loop
    }

    public static void exitNestedLoop() {
        //outer loop with counter i looping from 1 to 5
        //exit loop after 5 milliseconds
        long startTime = System.currentTimeMillis();//Time when we started.
        long timeToRun = 5; //How long we want to spend on our loop (in milliseconds)

        for (int i = 1; i <= 5; i++) {
            System.out.println("Outer loop, iteration number: " + i);
            //inner loop, for each value of i loop through with counter j from 1 to 3
            for (int j = 1; j <= 3; j++) {
                System.out.println("    Inner loop, iteration number: " + j);
                if ((System.currentTimeMillis() - startTime) > timeToRun) {
                    System.out.println("Time Expired!");
                    break;
                    //without labels this break will only stop the inner loop!
                }//end if      
            }//end inner loop
        }//end outer loop
    }//end exitNestedLoop
    
    public static void exitSpecificLoop() {
        //outer loop with counter i looping from 1 to 5
        //exit loop after 5 milliseconds
        long startTime = System.currentTimeMillis();//Time when we started.
        long timeToRun = 5; //How long we want to spend on our loop (in milliseconds)

        outer: //label to identify the following as the 'outer' for loop
        for (int i = 1; i <= 5; i++) {
            System.out.println("Outer loop, iteration number: " + i);
            //inner loop, for each value of i loop through with counter j from 1 to 3
            for (int j = 1; j <= 3; j++) {
                System.out.println("    Inner loop, iteration number: " + j);
                if ((System.currentTimeMillis() - startTime) > timeToRun) {
                    System.out.println("Time Expired!");
                    break outer;
                    //exit the outer loop.
                }//end if      
            }//end inner loop
        }//end outer loop
    }//end exitSpecificLoop

}
